// $Id: CAnimation.cpp,v 1.5 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CAnimation.hpp"
using Exponent::GUI::Controls::CAnimation;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CAnimation, CControl);

//	===========================================================================
CAnimation::CAnimation(IControlRoot *root, const long uniqueId, const CRect &area) 
		  : CControl(root, uniqueId, area)
		  , m_invertAnimationStrip(false)
		  , m_frameHeight(0)
		  , m_numberOfFrames(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CAnimation);
	this->setValue(0.0);
	this->controlIsMouseEnabled(false);
}

//	===========================================================================
CAnimation::~CAnimation()
{
	EXPONENT_CLASS_DESTRUCTION(CAnimation);
}

//	===========================================================================
void CAnimation::setAnimationImage(IImage *theImage, const long heightOfEachFrame, const long numberOfFrames, const bool invertAnimation)
{
	this->setPrimaryImage(theImage);

	// Now we can check it out :)
	if (m_primaryImage)
	{
		m_frameHeight    = heightOfEachFrame;
		m_numberOfFrames = numberOfFrames;
		m_offsetArea.setOrigin(CPoint(0, 0));
		m_offsetArea.setWidth(m_primaryImage->getImageSize().getWidth());
		m_offsetArea.setHeight(m_frameHeight);
	}

	m_invertAnimationStrip = invertAnimation;
}

//	===========================================================================
void CAnimation::setAnimationImage(CImageManager::CAnimationReference *animationReference, const bool invertAnimation)
{
	// Check if is valid
	if (animationReference)
	{
		// Get the size of the image
		long height, numberOfFrames;
		animationReference->getAnimationSizes(height, numberOfFrames);

		// Set!
		this->setAnimationImage(animationReference->getImage(), height, numberOfFrames, invertAnimation);
	}
}

//	===========================================================================
void CAnimation::drawControl(CGraphics &graphics)
{
	// First check if we can allow the standard handler to draw the disabled control
	if (!this->drawEnabledControl(graphics))
	{
		return;
	}

	if (m_value >= 0.0)
	{
		long top		 = 0;
		long frameNumber = (m_invertAnimationStrip) ? (long)((1.0 - m_value) * (m_numberOfFrames - 1)) : (long)(m_value * (m_numberOfFrames - 1));
		if (frameNumber < 0)
		{
            frameNumber += m_numberOfFrames;
		}
        if (frameNumber >= m_numberOfFrames)
		{
            frameNumber -= m_numberOfFrames;
		}
		top = m_frameHeight * frameNumber;
		m_offsetArea.setTop(top);
	}

	graphics.drawImage(m_primaryImage, m_normalisedArea, m_offsetArea);
}